/*
 * 	sample2.t				version 3.1
 *	by Kevin Forchione		( Lysseus@msn.com )
 *	Copyright (c) 1999. 	All Rights Reserved.
 *
 *  SAMPLE DEMONSTRATION GAME FOR SENSE.T
 *
 *  This file demonstrates the sense-passing aspects of sense.t,
 *  especially with regard to the sense of smell and hearing.
 *
 *  This file requires HTML TADS 2.5.1 or later.
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		02-Nov-99:	Creation.
 *      18-Jan-00:  Updated for sense 3.0
 *      23-Jan-00:  Updated for sense 3.1
 *      07-Apr-00:  Updated for sense 3.2 - changed cantReach to
 *                  cantTouch
 */

#define USE_CONTAINMENT

#include <basic_skel.t>
#include <sense.t>

/*
 *  startroom: room
 *
 *  The room will allow us to "hear" the hallway.
 */
modify startroom
    hearInto = hallway
;

table: surface
    location = startroom
    noun = 'table'
    adjective = 'wooden'
    sdesc = "wooden table"
;

/*
 *  radio: item
 *
 *  The radio is listed in room displays if it is turned on. When the
 *  player command is <<listen to radio>> we display the
 *  radio.listendesc if the radio is on; otherwise we display the
 *  inherited listendesc.
 */
radio: item
    location = table
    noun = 'radio'
    sdesc = "radio"
    isListedAudible = { return radioSwitch.isActive; }
    doListento(actor) = {
        if (radioSwitch.isActive)
            self.listendesc;
        else
            inherited.listendesc;
    }
    ldesc = "You notice only that the radio has a single switch."
    listendesc = "The sounds of the Beatles singing <q>Yesterday</q> 
        is clearly audible."
    doTurnon -> radioSwitch
;

radioSwitch: switchItem
    location = radio
    noun = 'switch'
    sdesc = "switch"
;

/*
 *  safe: openable
 *  
 *  The safe has contentsAudible returning true or nil based on whether
 *  it is open or closed. Closing the safe will prevent objects from
 *  being heard, either directly, <<listen to object>>; or indirectly
 *  <<listen>>.
 */
safe: openable
    location = startroom
    noun = 'safe'
    adjective = 'steel'
    contentsAudible = { return self.isopen; }
    sdesc = "steel safe"
    ldesc = { 
        "The thick walls of the safe appear to pretty sound-
        proof. ";
        pass ldesc;
    }
;    

/*
 *  hallway: room
 *  
 *  This room will now allow us to "smell" the kitchen.
 */
modify hallway
    smellInto = kitchen
;

/*
 *  bigClock: fixeditem
 *  
 *  The listendesc checks to see if the clock is visible to the actor
 *  along the path. If it is then we display a more specific message
 *  than we do when it isn't visible to the actor.
 */
bigClock: fixeditem
    location = hallway
    noun = 'clock'
    adjective = 'grandfather'
    isListedAudible = (true)
    sdesc = "grandfather clock"
    heredesc = "An old-fashioned grandfather clock stands in the hall."
    ldesc = "It appears to have been recently wound."
    listendesc = "The grandfather clock is ticking loudly. "
    listendesc_remote = "There is the sound of a clock ticking somewhere. ";
;

/*
 *  kitchen: room
 *
 *  From the kitchen we can hear into the hallway and backyard, as well
 *  as see into the backyard.
 */
modify kitchen
    hearInto = [hallway, backyard]
    seeInto = backyard
    smellInto = backyard
    cantSee(vantage, target) = {
        local o, plist;
        
        plist := path(vantage, target);
        o := getPlist(plist, PTH_TARGET);
        
        if (inPlist(plist, backyard))
        {
            "%You% will have to open the window in order to get a 
            closer view of <<o.thedesc>>. ";
        }
        else
            pass cantSee;
    }
    cantHear(vantage, target) = {
        local o, plist;
        
        plist := path(vantage, target);
        o := getPlist(plist, PTH_TARGET);
        if (inPlist(plist, backyard))
        {
            "%You% will have to open the window if you want to 
            hear <<o.thedesc>>. ";
        }
        else
            pass cantHear;
    }        
    cantSmell(vantage, target) = {
        local o, plist;
        
        plist := path(vantage, target);
        o := getPlist(plist, PTH_TARGET);
        
        if (inPlist(plist, backyard))
        {
            "%You% will have to open the window if you want to  
            smell <<o.thedesc>>. ";
        }
        else
            pass cantSmell;
    }
    cantTouch(vantage, target) = {
        local o, plist;
              
        plist := path(vantage, target);
        if (inPlist(plist, backyard))
        {
            o := getPlist(plist, PTH_TARGET);
            if (!window.isopen)
                "Even if the window were open, it is doubtful that 
                you could reach <<o.thedesc>>. ";
            else
                "\^<<o.thedesc>> is too far away. ";
        }
        else
            pass cantTouch;
    }
;

/* 
 *  cook: Actor
 *
 *  The cook demonstrates the default behaviours of an NPC, to contrast
 *  with those of a PC. NPC default sense-passing does *not* restrict
 *  objects being held by the NPC from being smelled or heard in room
 *  displays or directly.
 *
 *  PC sense-passing, by contrast does not display objects being held
 *  when indirectly smelled or heard.
 */
cook: Actor
    location = kitchen
    noun = 'cook'
    sdesc = "cook"
    actorDesc = "A beefy-looking cook is here, busily stirring a pot  
        of stew on the stove."
    actorAction( v, d, p, i ) = {}
;

modify stove
    contentsOlfactory = true
    contentsAudible = true
;

/*
 *  loaf: fooditem
 *
 *  The load is listed olfactory, which means that if access makes it
 *  along the path from the actor to the loaf then it should appear in 
 *  room display listings.
 *
 *  The smelldesc takes into account whether the bread is visible to the
 *  actor and whether the actor is in the same top-level location as the 
 *  bread.
 */
modify loaf
    isListedOlfactory = (true)
    smelldesc = {        
        if (testScope(command.actorPtr, self, &access_visible))
            "Smells like a fresh loaf of bread! ";
        else
            "The smell of baked bread is very strong here. ";
    }
    smelldesc_remote = "The faint smell of freshly baked bread wafts to your
            nostrils. "
;

sink: fixeditem, surface
    location = kitchen
    sdesc = "sink"
    noun = 'sink'
;

/*
 *  window: seethruItem, doorway
 *
 *  The window is used to restrict the passing of senses, depending upon
 *  whether it is open or closed. The window is not along the path
 *  between the actor and the backyard, but is used indirectly to
 *  control access.
 */
window: seethruItem, doorway
    location = kitchen
    noun = 'window'
    sdesc = "window"
    heredesc = "A small window stands above the sink."
    thrudesc = {
        "%You% gaze%s% through the window. ";
        backyard.ldesc;
    }
    doordest =
    {
        "The window is too small for you to pass through. ";
        return nil;
    }
;

/*
 *  backyard: room
 *
 *  There is no way to access the backyard except through senses.
 *  Because the isqVisible attribute returns true this object and its
 *  contents do not appear in extended room listings.
 */
backyard: room
    sdesc = "Back Yard"
    ldesc = {
        "The backyard is in a shabby state. The grass is unmown, and
        you can just make out an abandoned car hidden in the weeds. ";
        if (bottle.isIn(backyard))
            "A glass bottle lies in the grass, just beneath the 
            window. ";
    }
    isListed = nil
    isListedOlfactory = { return (window.isopen); }
    isqVisible = true
    isqOlfactory = { return (!window.isopen); }
    isqAudible = { return (!window.isopen); }
    smelldesc = "There is the faintest smell of jasmine from the
        backyard."
;

oldCar: vehicle
    location = backyard
    noun = 'car'
    adjective = 'abandoned' 'old'
    sdesc = "abandoned old car"
    adesc = "an <<self.sdesc>>"
    ldesc = "You can barely see the car through the weeds."
;

grass: fixeditem
    location = backyard
    noun = 'grass'
    sdesc = "grass"
    smelldesc = "The grass smells of decaying leaves."
;

bottle: transparentItem, openable
    location = backyard
    noun = 'bottle'
    adjective = 'glass'
    sdesc = "glass bottle"
    ldesc = "It appears to have some sort of insect in it."
    doListento -> cricket
;

cricket: item
    location = bottle
    noun = 'cricket' 'insect'
    sdesc = "cricket"
    isListedAudible = true
    listendesc = "The soft sound of chirping can be heard."
;
